###
### AllGenerics.R
###

if (!isGeneric("coefByModel")) {
  setGeneric("coefByModel", function(object, maxmodels, alpha=0.05, niter=10^3, burnin=round(niter/10)) standardGeneric("coefByModel"))
}

if (!isGeneric("coefOneModel")) {
  setGeneric("coefOneModel", function(y, x, m, V, outcometype, family, priorCoef, priorGroup, priorVar, alpha=0.05, niter=10^3, burnin=round(niter/10)) standardGeneric("coefOneModel"))
}


if (!isGeneric("dpimom")) {
    setGeneric("dpimom",
               function(x,
                        tau=1,
                        phi=1,
                        logscale=FALSE) standardGeneric("dpimom"))

}

if (!isGeneric("dpmom")) {
    setGeneric("dpmom",
               function(x,
                        tau,
                        a.tau,
                        b.tau,
                        phi=1,
                        r=1,
                        baseDensity='normal',
                        logscale=FALSE) standardGeneric("dpmom"))
}

if (!isGeneric("demom")) {
    setGeneric("demom",
               function(x,
                        tau,
                        a.tau,
                        b.tau,
                        phi=1,
                        logscale=FALSE) standardGeneric("demom"))
}


if (!isGeneric("marginalIW")) {
  setGeneric("marginalNIW", function(x, xbar, samplecov, n, z, g,  mu0=rep(0,ncol(x)), nu0=ncol(x)+4, S0,logscale=TRUE) standardGeneric("marginalNIW"))
}


if (!isGeneric("postProb")) {
  setGeneric("postProb", function(object, nmax, method='norm') standardGeneric("postProb"))
}


if (!isGeneric("postSamples")) {
    setGeneric("postSamples", function(object) standardGeneric("postSamples"))
}



if (!isGeneric("rnlp")) {
  setGeneric("rnlp", function(y, x, m, V, msfit, outcometype, family, priorCoef, priorGroup, priorVar, niter=10^3, burnin=round(niter/10), thinning=1, pp='norm') standardGeneric("rnlp"))
}

