% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/boxplotSort.R
\name{boxplotSort}
\alias{boxplotSort}
\title{Median-ordered box plot}
\usage{
boxplotSort(x, italic = FALSE, srt = 45, df = 0.5, varwidth = TRUE,
  col = NULL, ylab = "", main = "", clade = NULL)
}
\arguments{
\item{x}{a list, with species as the names of the list}

\item{italic}{if TRUE, the species names are italicized}

\item{srt}{the angle of the x-axis labels relative to the x-axis}

\item{df}{displacement factor for positioning x-axis labels}

\item{varwidth}{if TRUE, the width of the box plot for a species is proportional to the square root of the species's sample size}

\item{col}{a character vector specifying the box colors for two clades}

\item{ylab}{y-axis title}

\item{main}{title for the plot}

\item{clade}{a character vector specifying the species names for the first clade; currently supports only two clades}
}
\description{
This is a modification of the standard box plot to produce box plots ordered on the basis of descending median,
for more effective graphical representation of data.
}
\details{
The box plots produced using this function are helpful for documenting sample quality score distributions
of each species. They are also useful for checking the distribution of pairwise Euclidean distance between two landmarks.
}
\examples{
data(pwed_pd)
pwed_pd <- matrix2list.2(pwed_pd)

cladeI <- c("liewi","fenestrum","grandis","johorensis","kedahensis","kederai")
#We just want to look at distance between LM1 and LM3 in for dorsal anchor
boxplotSort(lapply(pwed_pd, function(k) k[,which(colnames(k)=="D1_3")]), italic=TRUE,
col=c("dodgerblue","violetred"), clade=cladeI,
ylab=expression(paste("Length ", "(", italic(mu),"m", ")")))

#Separation of two lineage seems possible at 15 micrometers
abline(h=15)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.
}
\seealso{
\code{\link{Qscore}}
}

