% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigram.R
\name{draw_bigram_network}
\alias{draw_bigram_network}
\alias{bigram}
\alias{bigram_depend}
\alias{bigram_network}
\alias{word_freq}
\alias{bigram_network_plot}
\title{Draw bigram network using morphological analysis data.}
\usage{
draw_bigram_network(df, draw = TRUE, ...)

bigram(df, group = "sentence", depend = FALSE, term_depend = NULL, ...)

bigram_depend(df, group = "sentence")

bigram_network(bigram, rand_seed = 12, threshold = 100, ...)

word_freq(df, big_net, ...)

bigram_network_plot(
  big_net,
  freq,
  ...,
  arrow_size = 5,
  circle_size = 5,
  text_size = 5,
  font_family = "",
  arrow_col = "darkgreen",
  circle_col = "skyblue",
  x_limits = NULL,
  y_limits = NULL,
  no_scale = FALSE
)
}
\arguments{
\item{df}{A dataframe including result of morphological analysis.}

\item{draw}{A logical.}

\item{...}{Extra arguments to internal fuctions.}

\item{group}{A string to specify sentence.}

\item{depend}{A logical.}

\item{term_depend}{A string of dependnt terms column to use bigram.}

\item{bigram}{A result of bigram().}

\item{rand_seed}{A numeric.}

\item{threshold}{A numeric used as threshold for frequency of bigram.}

\item{big_net}{A result of bigram_network().}

\item{freq}{A numeric of word frequency in bigram_network.
Can be got using word_freq().}

\item{arrow_size, circle_size, text_size, }{A numeric.}

\item{font_family}{A string.}

\item{arrow_col, circle_col}{A string to specicy arrow and circle color
in bigram network.}

\item{x_limits, y_limits}{A Pair of numeric to specify range.}

\item{no_scale}{A logical. FALSE: Not draw x and y axis.}
}
\value{
A list including df (input), bigram, freq (frequency) and
gg (ggplot2 object of bigram network plot).
}
\description{
Draw bigram network using morphological analysis data.
}
\examples{
library(magrittr)
data(synonym)
synonym <- unescape_utf(synonym)

data(neko_mecab)
neko_mecab <- 
  neko_mecab  \%>\%
  unescape_utf() \%>\%
  add_sentence_no() \%>\%
  clean_up(use_common_data = TRUE, synonym_df = synonym)

bigram_neko <- 
  neko_mecab \%>\%
  draw_bigram_network()

data(neko_ginza)
neko_ginza <- 
  neko_ginza \%>\%
  unescape_utf() \%>\%
  add_sentence_no() \%>\%
  clean_up(add_depend = TRUE, use_common_data = TRUE, synonym_df = synonym)

bigram_neko_ginza_dep <- 
  neko_ginza \%>\%
  bigram(depend = TRUE)

add_stop_words <- 
  c("\\\\u3042\\\\u308b", "\\\\u3059\\\\u308b", "\\\\u3066\\\\u308b", 
    "\\\\u3044\\\\u308b","\\\\u306e", "\\\\u306a\\\\u308b", "\\\\u304a\\\\u308b", 
    "\\\\u3093", "\\\\u308c\\\\u308b", "*") \%>\% 
   unescape_utf()

data(review_chamame)
bigram_review <- 
  review_chamame \%>\%
  unescape_utf() \%>\%
  add_sentence_no() \%>\%
  clean_up(add_stop_words = add_stop_words) \%>\%
  draw_bigram_network()

data(review_ginza)
review_ginza \%>\%
  unescape_utf() \%>\%
  add_sentence_no() \%>\%
  clean_up(add_depend = TRUE) \%>\%
  draw_bigram_network(depend = TRUE)

}
