% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{morphemepiece_tokenize}
\alias{morphemepiece_tokenize}
\title{Tokenize Sequence with Morpheme Pieces}
\usage{
morphemepiece_tokenize(
  text,
  vocab = morphemepiece_vocab(),
  lookup = morphemepiece_lookup(),
  unk_token = "[UNK]",
  max_chars = 100
)
}
\arguments{
\item{text}{Character scalar; text to tokenize.}

\item{vocab}{Named integer vector containing vocabulary words. Should have
"vocab_split" attribute, with components named "prefixes", "words",
"suffixes".}

\item{lookup}{A morphemepiece lookup table.}

\item{unk_token}{Token to represent unknown words.}

\item{max_chars}{Maximum length of word recognized.}
}
\value{
A character vector of tokenized text (later, this should be a named
integer vector, as in the wordpiece package.)
}
\description{
Given a single sequence of text and a morphemepiece vocabulary, tokenizes the
text.
}
