% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitTT.R
\name{ppc.survFitTT}
\alias{ppc.survFitTT}
\title{Posterior predictive check plot for survFitTT objects}
\usage{
\method{ppc}{survFitTT}(x, style = "generic", ...)
}
\arguments{
\item{x}{An object of class \code{survFitTT}}

\item{style}{Graphical package method: \code{generic} or \code{ggplot}.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
The \code{ppc} function plot the observed versus predicted values for the
\code{survFitTT} objects.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create an object of class "survData"
dat <- survData(cadmium1)

\dontrun{
# (3) Run the survFitTT function with the log-logistic binomial model
out <- survFitTT(dat, lcx = c(5, 10, 15, 20, 30, 50, 80),
quiet = TRUE)

# (4) Plot observed versus predicted values
ppc(out)
}

}

