% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survFitTT.R
\name{plot.survFitTT}
\alias{plot.survFitTT}
\title{Plotting method for \code{survFitTT} objects}
\usage{
\method{plot}{survFitTT}(x, xlab = "Concentration", ylab = "Survival rate",
  main = NULL, fitcol = "red", fitlty = 1, fitlwd = 1, ci = FALSE,
  cicol = "pink1", cilty = 1, cilwd = 1, addlegend = FALSE,
  log.scale = FALSE, style = "generic", ...)
}
\arguments{
\item{x}{an object of class \code{survFitTT}}

\item{xlab}{a title for the \eqn{x}-axis}

\item{ylab}{a title for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{fitcol}{color of the fitted curve}

\item{fitlty}{line type of the fitted curve}

\item{fitlwd}{width of the fitted curve}

\item{ci}{if \code{TRUE}, draws the 95 \% confidence interval on observed data}

\item{cicol}{color of the 95 \% confidence interval limits}

\item{cilty}{line type for the 95 \% confidence interval limits}

\item{cilwd}{width of the 95 \% confidence interval limits}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log scale}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
This function plots exposure-response fits for target time survival
analysis (a.k.a. \code{survFitTT} objects).
}
\details{
The fitted curve represents the \strong{estimated survival rate} after
the target time has passed as a function of the concentration of pollutant;
the black dots depict the \strong{observed survival rate} at each tested
concentration. Note that since our model does not take inter-replicate
variability into consideration, replicates are systematically pooled in this
plot. When \code{ci = TRUE}, the function plots both credible intervals for
the estimated survival rate (by default the red area around the fitted
curve) and confidence intervals for the observed survival rate (as black
error bars). Both types of intervals are taken at the same level. Typically
a good fit is expected to display a large overlap between the two intervals.
}
\note{
When \code{style = "ggplot"}, the function calls package
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.

For an example, see the paragraph on \code{\link{reproFitTT}}.
}
\keyword{plot}

