% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{first_three_args}
\alias{first_three_args}
\title{Handle the first three arguments of graphics functions}
\usage{
first_three_args(..., two_tildes = FALSE)
}
\arguments{
\item{\dots}{unnamed arguments to be translated into a list with the three canonical arguments
and any other arguments not named explicitly in the parent function definition.}

\item{two_tildes}{if \code{TRUE} then look for the first FOUR arguments, the middle
two of which will be tilde expressions.}
}
\description{
This function is intended for package developers, not end-users. Canonically, \code{mosaicCalc} functions that produce layerable graphics have
three initial arguments in a specific order: (1) a previous gg layer, (2) a tilde expression, and (3)
a domain. But either (1) or (3) can be missing. \code{first_three_args()} translates a leading
... argument into the list of the canonical three initial arguments, returning them
as components of a list.  In addition, there may be additional arguments
in ... that specify other aspects of the plot, e.g. color.
}
\details{
In constructing a mosaicCalc graphics layer, the function (e.g. \code{slice_plot()} or \code{contour_plot()})
whould have ... as its first argument. Intercept that ... with \code{first_three_args()} to
extract the first three canonical arguments as components \code{gg}, \code{tilde}, and \code{domain} of a
list. Any remaining arguments in ... will be placed in the \code{dots} component.
}
