% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_num_antiD.R
\name{create_num_antiD}
\alias{create_num_antiD}
\title{Create a numerical anti-derivative function which can be
called with one or many values of the w.r.t. input}
\usage{
create_num_antiD(tilde, ..., lower = NULL, .tol = 1e-04)
}
\arguments{
\item{tilde}{Tilde expression for the function to be anti-differentiated.
Right-hand side will be the w.r.t. variable}

\item{\dots}{arguments and parameters to the function described by \code{tilde}}

\item{lower}{Optional lower bound of integration. Useful to avoid domain
problems with the function being integrated, but not generally needed.}

\item{.tol}{Numerical tolerance for the integration}
}
\value{
a function with the w.r.t. variable as the first argument. The function
is a wrapper around numerical integration routines.
}
\description{
This will typically be called directly from \code{antiD()} when an
integral can't be handled symbolically.
}
