% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeODE.R
\name{makeODE}
\alias{makeODE}
\title{Create a dynamics object for use in \code{integrateODE()} and the ODE graphics}
\usage{
makeODE(...)
}
\arguments{
\item{\dots}{The components of an ODE and/or a set of other ODE objects}
}
\value{
a list containing various functions and values specifying the
ODE.
}
\description{
An ODE object consists of some dynamics, initial conditions, parameter values,
time domain, etc.
}
\examples{
SIR <- makeODE(dS~ -a*S*I, dI ~ a*S*I - b*I, a=0.0026, b=.5, S=762, I=1)
soln <- integrateODE(SIR, domain(t=0:20))

}
