% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_prune.R
\name{plot.multiscale.cpts}
\alias{plot.multiscale.cpts}
\title{Plotting multiscale.cpts change-points}
\usage{
\method{plot}{multiscale.cpts}(x, shaded = c("CI", "bandwidth")[1],
  level = 0.05, N_reps = 10000, CI = c("pw", "unif")[1], ...)
}
\arguments{
\item{x}{a \code{multiscale.cpts} object}

\item{shaded}{string indicating which to display as shaded area on the y-axis around change-point estimates.
Poissble values are \code{'bandwidth'} for the respective detection intervals and \code{'CI'} for (bootstrapped) confidence intervals}

\item{level, N_reps}{argument to be parsed to \link[mosum]{confint.multiscale.cpts}; use iff \code{shaded='CI'}}

\item{CI}{string indicating whether pointwise (\code{CI = 'pw'}) or uniform (\code{CI = 'unif'}) confidence intervals
shall be plotted; use iff \code{shaded='CI'}}

\item{...}{not in use}
}
\description{
Plotting method for objects of class 'multiscale.cpts'.
}
\details{
The input time series is plotted along with the estimated change-points
and their detection intervals (if \code{shaded='bandwidth'}) or bootstrap confidence intervals
of the corresponding change-points (if \code{shaded='CI'}). The y-axis represents \code{1-p.value}
for each estimated change-point derived from the asymptotic distribution of MOSUM statistics.
}
