% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{mt_plot_riverbed}
\alias{mt_plot_riverbed}
\title{Plot density of mouse positions across time steps.}
\usage{
mt_plot_riverbed(data, use = "tn_trajectories", y = "xpos",
  y_range = NULL, y_bins = 250, x_label = "Time step",
  y_label = "X coordinate")
}
\arguments{
\item{data}{mousetrap data object containing the data to be plotted.}

\item{use}{character string specifying the set of trajectories to use in the
plot. The steps of this set will constitute the x axis. Defaults to
'tn_trajectories', which results in time steps being plotted on the x axis.}

\item{y}{variable in the mousetrap data object to be plotted on the 
output's y dimension. Defaults to 'xpos', the cursor's x coordinate.}

\item{y_range}{numerical vector containing two values that represent the 
upper and lower ends of the y axis. By default, the range is calculated 
from the data provided.}

\item{y_bins}{number of bins to distribute along the y axis (defaults to
250).}

\item{x_label}{label placed on the output's x axis (defaults to 'Time step').}

\item{y_label}{label placed on the output's y axis (defaults to 'X 
coordinate', as appropriate given the default for \code{y}).}
}
\description{
\code{mt_plot_riverbed} creates a plot showing the relative frequency of
x-values per time step.
}
\details{
This plot indicates where the majority of trajectories lie, and the degree to
which trajectories deviate from the average trajectory. In most data sets,
this plot will result in a horizontal line of high density indicating that
participants took a certain amount of time before deviating from their
starting point.
}
\examples{
# Load ggplot2
library(ggplot2)

# Time-normalize trajectories
mt_example <- mt_time_normalize(mt_example)
  
# Create riverbed plot for all trials
mt_plot_riverbed(mt_example)


# Create separate plots for typical and atypical trials:

# assess range for x-positions across both conditions
xpos_range <- range(mt_example$tn_trajectories[,"xpos",])

# create subsets of trials
mt_example_atypical <- mt_subset(mt_example,Condition=="Atypical")
mt_example_typical <- mt_subset(mt_example,Condition=="Typical")

# create separate riverbed plots
mt_plot_riverbed(mt_example_atypical,
  use="tn_trajectories", y_range=xpos_range)+
  ggtitle("Atypical condition")

mt_plot_riverbed(mt_example_typical,
  use="tn_trajectories", y_range=xpos_range)+
  ggtitle("Typical condition")

}
\seealso{
\link{mt_plot} for plotting trajectory data.
}

