% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{mt_import_long}
\alias{mt_import_long}
\title{Import mouse-tracking data saved in long format.}
\usage{
mt_import_long(raw_data, xpos_label = "xpos", ypos_label = "ypos",
  timestamps_label = "timestamps", dist_label = "dist", vel_label = "vel",
  acc_label = "acc", mt_id_label = mt_id, mt_seq_label = "mt_seq",
  reset_timestamps = TRUE)
}
\arguments{
\item{raw_data}{a data.frame in long format, containing the raw data.}

\item{xpos_label}{a character string specifying the column containing the
x-positions.}

\item{ypos_label}{a character string specifying the column containing the
y-positions.}

\item{timestamps_label}{a character string specifying the column containing
the timestamps.}

\item{dist_label}{a character string specifying the column containing the
distance traveled.}

\item{vel_label}{a character string specifying the column containing the
velocity.}

\item{acc_label}{a character string specifying the column containing the
acceleration.}

\item{mt_id_label}{a character string specifying the column that provides a
unique ID for every trial.}

\item{mt_seq_label}{a character string specifying the column that indicactes
the order of the logged coordinates within a trial. If unspecified, the
coordinates will be ordered according to their timestamps.}

\item{reset_timestamps}{logical indicating if the first timestamp should be
subtracted from all timestamps within a trial. Default is TRUE as it is
recommended for all following analyses in mousetrap.}
}
\value{
A mousetrap data object (see \link{mt_example}).
}
\description{
\code{mt_import_long} receives a data.frame in which mouse-tracking data are
stored in long format, i.e., where one row contains the logging data
(timestamp, x- and y-position etc.) at one specific point in the trial. This
is, for example, the case when exporting the trajectory data from the
mousetrap package using \link{mt_reshape}. From this data.frame,
\code{mt_import_long} creates a mousetrap data object containing the
trajectories and additional data for further processing within the mousetrap
package. \code{mt_import_long} returns a list, which includes the trajectory
data as an array, and all other data as a data.frame. This data structure can
then be passed on to other functions within this package, such as
\link{mt_time_normalize} or \link{mt_calculate_measures}. The defaults are
set so that no adjustments have to be made when importing a data.frame that
was created using \link{mt_reshape}.
}
\details{
The coordinates are ordered according to the values in the column provided in
the \code{mt_seq_label} parameter (\code{mt_seq} by default). If the
corresponding column does not exist, the coordinates will be ordered
according to their timestamps (drawn from the \code{timestamps} column by
default).
}
\examples{
\dontrun{
exp_data <- read.csv("exp_data.csv")
data <- mt_import_long(exp_data)
}
}
\seealso{
\link{mt_import_mousetrap} and \link{mt_import_wide} for importing
mouse-tracking data from other sources.
}

