% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bimodality.R
\name{bimodality_coefficient}
\alias{bimodality_coefficient}
\title{Calculate bimodality coefficient.}
\usage{
bimodality_coefficient(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{na.rm}{logical specifying whether missing values should be removed.}
}
\value{
A numeric value.
}
\description{
Calculate the bimodality coefficient for a numeric vector as specified in
Pfister et al. (2013).
}
\details{
The calculation of the bimodality coefficient involves calculating the
skewness and kurtosis of the distribution first. For this, the
\link[psych]{skew} and \link[psych:skew]{kurtosi} functions of the \code{psych}
package are used.
Note that type is set to "2" for these functions in accordance with 
Pfister et al. (2013).
}
\examples{
pfister_data_a <- rep(1:11, times=c(3,5,5,10,17,20,17,10,5,5,3))
bimodality_coefficient(pfister_data_a) #.34
pfister_data_b <- rep(1:11, times=c(2,26,14,6,2,0,2,6,14,26,2))
bimodality_coefficient(pfister_data_b) #.79

}
\references{
Pfister, R., Schwarz, K. A., Janczyk, M., Dale, R., & Freeman, J. B. (2013).
Good things peak in pairs: A note on the bimodality coefficient.
\emph{Frontiers in Psychology, 4}, 700.
\url{http://dx.doi.org/10.3389/fpsyg.2013.00700}
}
\seealso{
\link[psych]{skew} for calculating skewness and kurtosis.

  \link{mt_check_bimodality} for assessing bimodality using several methods in
  a mousetrap data object.
}
\author{
Pascal J. Kieslich

Felix Henninger
}
