% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_maptypes.R
\name{get_maptypes}
\alias{get_maptypes}
\title{Get all supported map types}
\usage{
get_maptypes(map_service = NULL)
}
\arguments{
\item{map_service}{character, optional, either \code{"osm"}, \code{"carto"} or \code{"mapbox"}. Otherwise, a list of map types for both services is returned.}
}
\value{
A character vector of supported map types
}
\description{
This function returns every supported map type that can be used as input to the \code{map_type} argument of \code{\link{frames_spatial}}.
}
\examples{
# for all services
get_maptypes()

# for osm only
get_maptypes("osm")
# or
get_maptypes()$osm

# for mapbox only
get_maptypes("mapbox")
# or
get_maptypes()$mapbox

# same for all other map services

}
\seealso{
\code{\link{frames_spatial}}
}
