% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_progress.R
\name{add_progress}
\alias{add_progress}
\title{Add progress bar to frames}
\usage{
add_progress(frames, colour = "grey", size = 1.8, verbose = TRUE)
}
\arguments{
\item{frames}{list of \code{ggplot2} objects, crated with \code{\link{frames_spatial}}.}

\item{colour}{character, progress bar colour.}

\item{size}{numeric, progress bar line size..}

\item{verbose}{logical, if \code{TRUE}, messages and progress information are displayed on the console (default).}
}
\value{
List of frames.
}
\description{
This function adds a progress bar to animation frames created with \code{\link{frames_spatial}}.
}
\examples{
library(moveVis)
library(move)

data("move_data", "basemap_data")
m <- align_move(move_data, res = 4, unit = "mins")

# create spatial frames using a custom NDVI base layer
r_list <- basemap_data[[1]]
r_times <- basemap_data[[2]]

\donttest{
frames <- frames_spatial(m, r_list = r_list, r_times = r_times, r_type = "gradient",
                         fade_raster = TRUE)

# add a progress bar:
frames.a <- add_progress(frames)
frames.a[[100]]

# or in red and larger
frames.b <- add_progress(frames, colour = "red", size = 2.5)
frames.b[[100]]
}

}
\seealso{
\code{\link{frames_spatial}} \code{\link{frames_graph}} \code{\link{animate_frames}}
}
\author{
Jakob Schwalb-Willmann
}
