% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernstein.R
\name{bernsteinApprox}
\alias{bernsteinApprox}
\title{Bernstein polynomial approximation}
\usage{
bernsteinApprox(f, n, lower = 0, upper = 1, indeterminate = "x")
}
\arguments{
\item{f}{the function to approximate}

\item{n}{Bernstein polynomial degree}

\item{lower}{lower bound for approximation}

\item{upper}{upper bound for approximation}

\item{indeterminate}{indeterminate}
}
\value{
a mpoly object
}
\description{
Bernstein polynomial approximation
}
\examples{





\dontrun{  # visualize the bernstein polynomials

library(ggplot2); theme_set(theme_bw())
library(reshape2)




f <- function(x) sin(2*pi*x)
p <- bernsteinApprox(f, 20) 
round(p, 3)

x <- seq(0, 1, length.out = 101)
df <- data.frame(
  x = rep(x, 2), 
  y = c(f(x), as.function(p)(x)), 
  which = rep(c("actual", "approx"), each = 101)
)
qplot(x, y, data = df, geom = "line", color = which)






p <- bernsteinApprox(sin, 20, pi/2, 1.5*pi) 
round(p, 4)

x <- seq(0, 2*pi, length.out = 101)
df <- data.frame(
  x = rep(x, 2), 
  y = c(sin(x), as.function(p)(x)), 
  which = rep(c("actual", "approx"), each = 101)
)
qplot(x, y, data = df, geom = "line", color = which)








p <- bernsteinApprox(dnorm, 15, -1.25, 1.25) 
round(p, 4)

x <- seq(-3, 3, length.out = 101)
df <- data.frame(
  x = rep(x, 2), 
  y = c(dnorm(x), as.function(p)(x)), 
  which = rep(c("actual", "approx"), each = 101)
)
qplot(x, y, data = df, geom = "line", color = which)






}

}
\author{
David Kahle
}
