% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrPerformancePlot.R
\name{mrPerformancePlot}
\alias{mrPerformancePlot}
\title{Plot Model Performance Comparison}
\usage{
mrPerformancePlot(
  ModelPerf1 = NULL,
  ModelPerf2 = NULL,
  mode = "classification"
)
}
\arguments{
\item{ModelPerf1, ModelPerf2}{Two data frames of model performance metrics to
compare. The data frames are created by \link{mrIMLperformance}, see \strong{Examples}.}

\item{mode}{A character string describing the mode of the models. Should be
either "regression" or "classification". The default is "classification".}
}
\value{
A list containing:
\itemize{
\item \verb{$performance_plot}: A box plot of model performance metrics.
\item \verb{$performance_diff_plot}: A bar plot of the differences in
performance metrics.
\item \verb{$performance_diff_df}: A data frame in wide format containing model
performance metrics and their differences.
}
}
\description{
Create visualizations to compare the performance of two models based on their
performance metrics generated by \link{mrIMLperformance}.
}
\examples{
MR_perf_rf <-  mrIML::mrIML_bird_parasites_RF \%>\%
  mrIMLperformance()
MR_perf_lm <- mrIML::mrIML_bird_parasites_LM\%>\%
  mrIMLperformance()

perf_comp <- mrPerformancePlot(
  ModelPerf1 = MR_perf_rf,
  ModelPerf2 = MR_perf_lm
)

}
