% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setinitial.ds.R
\name{setinitial.ds}
\alias{sethazard}
\alias{setinitial.ds}
\title{Set initial values for detection function based on distance sampling}
\usage{
setinitial.ds(ddfobj, width, initial, point, left)
       sethazard(ddfobj, dmat, width, left)
}
\arguments{
\item{ddfobj}{distance detection function object}

\item{width}{half-width of transect or radius of point count}

\item{initial}{list of user-defined initial values with possible elements
scale,shape,adjustment}

\item{point}{if TRUE, point count data; otherwise, line transect data}

\item{left}{left truncation}

\item{dmat}{xmat from ddfobj}
}
\value{
\item{scale}{vector of initial scale parameter values}
  \item{shape}{vector of initial shape parameter values}
  \item{adjustment}{vector of initial adjustment function parameter values}
}
\description{
For a given detection function, it computes the initial values for the
parameters including scale and shape parameters and adjustment function
parameters if any.  If there are user-defined initial values only the
parameters not specified by the user are computed.
}
\author{
Jeff Laake, David L Miller
}

