% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.ddf.R
\name{qqplot.ddf}
\alias{qqplot.ddf}
\title{Quantile-quantile plot and goodness of fit tests for detection functions}
\usage{
qqplot.ddf(model, plot = TRUE, nboot = 100, ks = FALSE, ...)
}
\arguments{
\item{model}{fitted distance detection function model object}

\item{plot}{the Q-Q plot be plotted or just report statistics?}

\item{nboot}{number of replicates to use to calculate p-values for the goodness of fit test statistics}

\item{ks}{perform the Kolmogorov-Smirnov test (this involves many bootstraps so can take a while)}

\item{\dots}{additional arguments passed to \code{\link{plot}}}
}
\value{
A list of goodness of fit related values: \item{edf}{matrix of lower
  and upper empirical distribution function values} \item{cdf}{fitted
  cumulative distribution function values} \item{ks}{list with K-S statistic
  (\code{Dn}) and p-value (\code{p})} \item{CvM}{list with CvM statistic
  (\code{W}) and p-value (\code{p})}
}
\description{
Constructs a quantile-quantile (Q-Q) plot for fitted model as a graphical check of goodness of fit. Formal goodness of fit testing for detection function models using Kolmogorov-Smirnov and Cramer-von Mises tests. Both tests are based on looking at the quantile-quantile plot produced by \code{\link{qqplot.ddf}} and deviations from the line x=y.
}
\details{
The Kolmogorov-Smirnov test asks the question "what's the largest vertical distance between a point and the y=x line?" It uses this distance as a statistic to test the null hypothesis that the samples (EDF and CDF in our case) are from the same distribution (and hence our model fits well). If the deviation between the y=x line and the points is too large we reject the null hypothesis and say the model doesn't have a good fit.

Rather than looking at the single biggest difference between the y=x line and the points in the Q-Q plot, we might prefer to think about all the differences between line and points, since there may be many smaller differences that we want to take into account rather than looking for one large deviation. Its null hypothesis is the same, but the statistic it uses is the sum of the deviations from each of the point to the line.
}
\section{Details}{

Note that a bootstrap procedure is required to ensure that the p-values from the procedure are correct as the we are comparing the cumulative distribution function (CDF) and empirical distribution function (EDF) and we have estimated the parameters of the detection function.
}

\references{
Burnham, K.P., S.T. Buckland, J.L. Laake, D.L. Borchers, T.A.
  Marques, J.R.B. Bishop, and L. Thomas. 2004.  Further topics in distance
  sampling. pp: 385-389. In: Advanced Distance Sampling, eds. S.T. Buckland,
  D.R.Anderson, K.P. Burnham, J.L. Laake, D.L. Borchers, and L. Thomas.
  Oxford University Press.
}
\seealso{
\code{\link{ddf.gof}}, \code{\link{cdf.ds}}
}
\author{
Jeff Laake, David L Miller
}
\keyword{utility}
