% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeltaMethod.R
\name{DeltaMethod}
\alias{DeltaMethod}
\title{Numeric Delta Method approximation for the variance-covariance matrix}
\usage{
DeltaMethod(par, fct, vcov, delta, ...)
}
\arguments{
\item{par}{vector of parameter values at which estimates should be constructed}

\item{fct}{function that constructs estimates from parameters \code{par}}

\item{vcov}{variance-covariance matrix of the parameters}

\item{delta}{proportional change in parameters used to numerically estimate
first derivative with central-difference formula}

\item{\dots}{any additional arguments needed by \code{fct}}
}
\value{
a list with values \item{variance}{estimated variance-covariance
matrix of estimates derived by \code{fct}} \item{partial}{ matrix (or
vector) of partial derivatives of \code{fct} with respect to the parameters
\code{par}}
}
\description{
Computes delta method variance-covariance matrix of results of any generic
function \code{fct} that computes a vector of estimates as a function of a
set of estimated parameters \code{par}.
}
\details{
The delta method (aka propagation of errors is based on Taylor series
approximation - see Seber's book on Estimation of Animal Abundance). It uses
the first derivative of \code{fct} with respect to \code{par} which is
computed in this function numerically using the central-difference formula.
It also uses the variance-covariance matrix of the estimated parameters
which is derived in estimating the parameters and is an input argument.

The first argument of \code{fct} should be \code{par} which is a vector of
parameter estimates. It should return a single value (or vector) of
estimate(s).  The remaining arguments of \code{fct} if any can be passed to
\code{fct} by including them at the end of the call to \code{DeltaMethod} as
\code{name=value} pairs.
}
\note{
This is a generic function that can be used in any setting beyond the
\code{mrds} package. However this is an internal function for \code{mrds}
and the user does not need to call it explicitly.
}
\author{
Jeff Laake
}
\keyword{utility}
