% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_gaz_wmses.R
\name{gaz_rest_wmses}
\alias{gaz_rest_wmses}
\title{Get WMS information for a given MRGID}
\usage{
gaz_rest_wmses(mrgid)
}
\arguments{
\item{mrgid}{(integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})}
}
\value{
a data frame with information from the WMS services including:
\itemize{
\item \code{value}: the value to filter on
\item \code{MRGID} : see \link{MRGID}
\item \code{url}: the base URL of the WMS service
\item \code{namespace}: see \code{\link[=mrp_view]{mrp_view()}} details
\item \code{featureType}: see \code{\link[=mrp_view]{mrp_view()}} details
\item \code{featureName}: see \code{\link[=mrp_view]{mrp_view()}} details
}
}
\description{
Get WMS information for a given MRGID
}
\examples{
\donttest{
gaz_rest_wmses(3293)
}
}
\seealso{
\link{gaz_rest}, \link{MRGID}, \code{\link[=mrp_view]{mrp_view()}}
}
