% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locker.R
\name{setup_locker}
\alias{setup_locker}
\title{Set up a data storage locker}
\usage{
setup_locker(where, tag = locker_tag(where))
}
\arguments{
\item{where}{The directory that contains tagged directories of run
results.}

\item{tag}{The name of a folder under \code{where}; this directory must not
exist the first time the locker is set up and \strong{will be deleted} and
re-created each time it is used to store output from a new simulation run.}
}
\value{
The locker location.
}
\description{
A locker is a directory structure where an enclosing folder contains
subfolders that in turn contain the results of different simulation runs.
When the number of simulation result sets is known, a stream of file names
is returned. This function is mainly called by other functions; an exported
function and documentation is provided in order to better communicate how
the locker works.
}
\details{
\code{where} must exist when setting up the locker. The directory \code{tag} will be
created under \code{where} and must not exist except if it had previously been
set up using \code{setup_locker}. Existing \code{tag} directories will have a
hidden file in them indicating that they are established simulation output
folders.

When recreating the \code{tag} directory, it will be unlinked and created new.
To not try to set up a locker directory that already contains outputs that
need to be preserved. You can call \code{\link[=noreset_locker]{noreset_locker()}} on that directory
to prevent future resets.
}
\examples{
x <- setup_locker(tempdir(), tag = "my-sims")
x

}
\seealso{
\code{\link[=reset_locker]{reset_locker()}}, \code{\link[=noreset_locker]{noreset_locker()}}, \code{\link[=version_locker]{version_locker()}}
}
