% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{mrgsolve}
\alias{mrgsolve}
\alias{mrgsolve-package}
\title{mrgsolve}
\description{
mrgsolve is an R package maintained under the auspices of Metrum Research Group, LLC, that facilitates
simulation from models based on systems of ordinary differential equations (ODE) that are typically employed
for understanding pharmacokinetics, pharmacodynamics, and systems biology and pharmacology.
mrgsovle consists of computer code written in the R and C++ languages, providing an interface to
the DLSODA differential equation solver (written in FORTRAN) provided through ODEPACK -
A Systematized Collection of ODE Solvers.
}
\section{Example models}{

See \code{\link{mrgsolve_example}} to export example models into your own, writeable project directory.
}

\section{Input data sets}{

See \code{\link{data_set}} for help creating input data sets.  See \code{\link{exdatasets}} for example input data sets.
}

\section{Package help}{

\itemize{
 \item  Package \href{00Index.html}{index}, including a listing of all functions
 \item Reserved words in \code{mrgsolve}: \code{\link[mrgsolve]{reserved}}
}
}

\section{About the model object}{

The model object has class \code{\link[=mrgmod-class]{mrgmod}}.
}

\section{Handling simulated output}{

See \code{\link{mrgsims}} for methods to use with simulated output.
}

\section{About the solver used by \code{mrgsolve}}{

See: \code{\link{aboutsolver}}
}

\examples{

## example("mrgsolve")

mod <- mrgsolve:::house(delta=0.1)  \%>\% param(CL=0.5)

events <-  ev(amt=1000, cmt=1, addl=5, ii=24)

events

mod

see(mod)

stime(mod)

param(mod)
init(mod)

out <- mod \%>\% ev(events) \%>\% mrgsim(end=168)

out

head(out)
tail(out)
dim(out)

plot(out, GUT+CP~.)

sims <- as.data.frame(out)

t72 <- subset(sims, time==72)
str(t72)

idata <- data.frame(ID=c(1,2,3), CL=c(0.5,1,2),VC=12)
out <- mod \%>\% ev(events) \%>\% mrgsim(end=168, idata=idata, req="")
plot(out)

out <- mod \%>\% ev(events) \%>\% mrgsim(carry.out="amt,evid,cmt,CL")
head(out)

out <- 
  mod \%>\% 
  ev() \%>\% 
  knobs(CL=c(0.5, 1,2), amt=c(100,300,1000), cmt=1,end=48)

plot(out, CP~., scales="same")
plot(out, RESP+CP~time|amt,groups=CL)


ev1 <- ev(amt=500, cmt=2,rate=10)
ev2 <- ev(amt=100, cmt=1, time=54, ii=8, addl=10)
events <- ev1+ev2
events

out <- mod \%>\% ev(ev1+ev2) \%>\% mrgsim(end=180, req="")
plot(out)



## "Condensed" data set
data(extran1)
extran1

out <- mod \%>\% data_set(extran1) \%>\% mrgsim(end=200)

plot(out,CP~time|factor(ID))


## idata
data(exidata)
exidata

out <- 
  mod \%>\% 
  ev(amt=1000, cmt=1) \%>\% 
  idata_set(exidata) \%>\%  
  mrgsim(end=72)

plot(out, CP~., as="log10")


# Internal model library
\dontrun{
mod <- mread("irm1", modlib())

mod

mod \%>\% ev(amt=300, ii=12, addl=3) \%>\% mrgsim
}

}
