% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.probtrans.R
\name{summary.probtrans}
\alias{summary.probtrans}
\title{Summary method for a probtrans object}
\usage{
\method{summary}{probtrans}(
  object,
  times,
  from = 1,
  to = 0,
  variance = TRUE,
  conf.int = 0.95,
  conf.type = c("log", "none", "plain"),
  extend = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class 'probtrans', containing estimated transition
probabilities from and to all states in a multi-state model}

\item{times}{Time points at which to evaluate the transition probabilites}

\item{from}{Specifies from which state the transition probabilities are to
be printed. Should be subset of 1:S, with S the number of states in the
multi-state model. Default is print from state 1 only. User can specify
from=0 to print transition probabilities from all states}

\item{to}{Specifies the transition probabilities to which state are to be
printed. User can specify to=0 to print transition probabilities to all
states. This is also the default}

\item{variance}{Whether or not the standard errors of the estimated
transition probabilities should be printed; default is \code{TRUE}}

\item{conf.int}{The proportion to be covered by the confidence intervals,
default is 0.95}

\item{conf.type}{The type of confidence interval, one of "log", "none", or
"plain". Defaults to "log"}

\item{extend}{logical value: if \code{TRUE}, prints information for all
specified times, even if there are no subjects left at the end of the
specified times. This is only valid if the times argument is present}

\item{\dots}{Further arguments to print}
}
\value{
Function \code{summary.probtrans} returns an object of class
"summary.probtrans", which is a list (for each \code{from} state) of
transition probabilities at the specified (or all) time points. The
\code{print} method of a \code{summary.probtrans} doesn't return a value.
}
\description{
Summary method for an object of class 'probtrans'. It prints a selection of
the estimated transition probabilities, and, if requested, also of the
variances.
}
\examples{

# First run the example of probtrans
tmat <- trans.illdeath()
tg <- data.frame(illt=c(1,1,6,6,8,9),ills=c(1,0,1,1,0,1),
                 dt=c(5,1,9,7,8,12),ds=c(1,1,1,1,1,1),
                 x1=c(1,1,1,0,0,0),x2=c(6:1))
tglong <- msprep(time=c(NA,"illt","dt"),status=c(NA,"ills","ds"),
                 data=tg,keep=c("x1","x2"),trans=tmat)
tglong <- expand.covs(tglong,c("x1","x2"))
cx <- coxph(Surv(Tstart,Tstop,status)~x1.1+x2.2+strata(trans),
            data=tglong,method="breslow")
newdata <- data.frame(trans=1:3,x1.1=c(0,0,0),x2.2=c(0,1,0),strata=1:3)
HvH <- msfit(cx,newdata,trans=tmat)
pt <- probtrans(HvH,predt=0)

# Default, prediction from state 1
summary(pt)
# Only from states 1 and 3
summary(pt, from=c(1, 3))
# Use from=0 for prediction from all states
summary(pt, from=0)
# Only to states 1 and 2
summary(pt, to=1:2)
# Default is 95\% confidence interval, change here to 90\% 
summary(pt, to=1:2, conf.int=0.90)
# Do not show variances (nor confidence intervals)
summary(pt, to=1:2, variance=FALSE)
# Transition probabilities only at specified time points
summary(pt, times=seq(0, 15, by=3))
# Last specified time point is larger than last observed, not printed
# Use extend=TRUE as in summary.survfit
summary(pt, times=seq(0, 15, by=3), extend=TRUE)
# Different types of confidence intervals, default is log
summary(pt, times=seq(0, 15, by=3), conf.type="plain")
summary(pt, times=seq(0, 15, by=3), conf.type="no")
# When the number of time points specified is larger than 12, head and tail is shown
x <- summary(pt, times=seq(5, 8, by=0.25))
x

}
\seealso{
\code{\link{probtrans}}
}
\author{
Hein Putter \email{H.Putter@lumc.nl}
}
\keyword{print}
