% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtag.R
\name{is.summarised}
\alias{is.summarised}
\title{Extract if the argument is already summarised}
\usage{
is.summarised(x, quiet = FALSE)
}
\arguments{
\item{x}{The object}

\item{quiet}{Pass \code{TRUE} to supress warnings on coersion to a qualifier/tag structure.}
}
\value{
\code{TRUE} if the argument is summarised, \code{FALSE} otherwise
}
\description{
Checks the \code{nrow()} of sub-data frames produced by \code{group_by()}.
Returns \code{all(lengths==1)}.
}
\examples{
data(pocmaj)
pocmaj <- as.qtag(pocmaj, c("core", "depth"))
is.summarised(pocmaj)
is.summarised(aggregate(pocmaj))

}

