% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem_dadas.R
\name{sem_dadas}
\alias{sem_dadas}
\title{Predicting algebraic difference scores in structural equation model}
\usage{
sem_dadas(
  data,
  var1,
  var2,
  center = FALSE,
  scale = FALSE,
  predictor,
  estimator = "MLR",
  level = 0.95,
  sampling.weights = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{var1}{Character string. Variable name of first component score of difference score (Y_1).}

\item{var2}{Character string. Variable name of second component score of difference score (Y_2).}

\item{center}{Logical. Are var1 and var2 centered around their grand mean? (Default FALSE)}

\item{scale}{Logical. Are var1 and var2 scaled with their pooled sd? (Default FALSE)}

\item{predictor}{Character string. Variable name of independent variable predicting difference score.}

\item{estimator}{Character string. Estimator used in SEM (Default "MLR").}

\item{level}{Numeric. The confidence level required for the result output (Default .95)}

\item{sampling.weights}{Character string. Name of sampling weights variable.}
}
\value{
\item{descriptives}{Means, standard deviations, and intercorrelations.}
\item{parameter_estimates}{Parameter estimates from the structural equation model.}
\item{variances}{F test and Fligner-Killeen test for homogeneity of variances between var1 and var2.}
\item{transformed_data}{Data frame with variables used in SEM.}
\item{dadas}{One sided dadas-test for positivity of abs(b_11-b_21)-abs(b_11+b_21).}
\item{results}{Summary of key results.}
}
\description{
Predicting algebraic difference scores in structural equation model
}
\examples{
set.seed(342356)
d <- data.frame(
  var1 = rnorm(50),
  var2 = rnorm(50),
  x = rnorm(50)
)
sem_dadas(
  data = d, var1 = "var1", var2 = "var2",
  predictor = "x", center = TRUE, scale = TRUE
)
}
\references{
Edwards, J. R. (1995). Alternatives to Difference Scores as Dependent Variables in the Study of Congruence in Organizational Research. Organizational Behavior and Human Decision Processes, 64(3), 307–324.
}
