% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee.R
\name{gee_fit}
\alias{gee_fit}
\title{GEE fitting function}
\usage{
gee_fit(formula, data, family = gaussian, ...)
}
\arguments{
\item{formula}{Normal formula but uses the \code{gee_formula()} internal
function for the \code{id_var()} specification for clustering.}

\item{data}{Modeling data}

\item{family}{a family object: a list of functions and expressions for
defining link and variance functions. Families supported in gee are
\code{gaussian}, \code{binomial}, \code{poisson}, \code{Gamma}, and \code{quasi}; see the \code{glm} and
\code{family} documentation. Some links are not currently available: \code{1/mu^2} and
\code{sqrt} have not been hard-coded in the \code{cgee} engine at present. The inverse
gaussian variance function is not available. All combinations of remaining
functions can be obtained either by family selection or by the use of
\code{quasi.}}

\item{...}{For additional parameters}
}
\value{
A gee object
}
\description{
Custom fitting function to add GEE model with cluster
variable to parsnip GEE function call.
}
\details{
\code{gee()} always prints out warnings and output even when
\code{silent = TRUE}. \code{gee_fit()} will never produce output, even if
\code{silent = FALSE}.

Also, because of issues with the \code{gee()} function, a supplementary call to
\code{glm()} is needed to get the rank and QR decomposition objects so that
\code{predict()} can be used.
}
\keyword{internal}
