% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nma-class.R
\name{plot_integration_error}
\alias{plot_integration_error}
\title{Plot numerical integration error}
\usage{
plot_integration_error(
  x,
  ...,
  stat = "violin",
  orientation = c("vertical", "horizontal", "x", "y"),
  show_expected_rate = TRUE
)
}
\arguments{
\item{x}{An object of type \code{stan_mlnmr}}

\item{...}{Additional arguments passed to the \code{ggdist} plot stat.}

\item{stat}{Character string specifying the \code{ggdist} plot stat used to
summarise the integration error over the posterior. Default is \code{"violin"},
which is equivalent to \code{"eye"} with some cosmetic tweaks.}

\item{orientation}{Whether the \code{ggdist} geom is drawn horizontally
(\code{"horizontal"}) or vertically (\code{"vertical"}), default \code{"vertical"}}

\item{show_expected_rate}{Logical, show typical convergence rate \eqn{1/N}?
Default \code{TRUE}.}
}
\value{
A \code{ggplot} object.
}
\description{
For ML-NMR models, plot the estimated numerical integration error over the
entire posterior distribution, as the number of integration points increases.
See \insertCite{methods_paper,Phillippo_thesis}{multinma} for details.
}
\details{
The total number of integration points is set by the \code{n_int}
argument to \code{\link[=add_integration]{add_integration()}}, and the intervals at which integration
error is estimated are set by the \code{int_thin} argument to \code{\link[=nma]{nma()}}. The
typical convergence rate of Quasi-Monte Carlo integration (as used here) is
\eqn{1/N}, which by default is displayed on the plot output.

The integration error at each thinning interval \eqn{N_\mathrm{thin}}{N_thin} is
estimated for each point in the posterior distribution by subtracting the
final estimate (using all \code{n_int} points) from the estimate using only the
first \eqn{N_\mathrm{thin}}{N_thin} points.
}
\examples{
## Plaque psoriasis ML-NMR
\donttest{
# Run plaque psoriasis ML-NMR example if not already available
if (!exists("pso_fit")) example("example_pso_mlnmr")
}
\donttest{
# Plot numerical integration error
plot_integration_error(pso_fit)
}
}
