% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma.R
\name{RE_cor}
\alias{RE_cor}
\alias{which_RE}
\title{Random effects structure}
\usage{
RE_cor(study, trt, contrast, type = c("reftrt", "blshift"))

which_RE(study, trt, contrast, type = c("reftrt", "blshift"))
}
\arguments{
\item{study}{A vector of study IDs (integer, character, or factor)}

\item{trt}{A factor vector of treatment codes (or coercible as such), with
first level indicating the reference treatment}

\item{contrast}{A logical vector, of the same length as \code{study} and \code{trt},
indicating whether the corresponding data are in contrast rather than arm
format.}

\item{type}{Character string, whether to generate RE structure under the
"reference treatment" parameterisation, or the "baseline shift"
parameterisation.}
}
\value{
For \code{RE_cor()}, a correlation matrix of dimension equal to the number
of random effects deltas (excluding those that are set equal to zero).

For \code{which_RE()}, an integer vector of IDs indexing the rows and columns of
the correlation matrix returned by \code{RE_cor()}.
}
\description{
Use \code{RE_cor} to generate the random effects correlation matrix, under the
assumption of common heterogeneity variance (i.e. all within-study
correlations are 0.5). Use \code{which_RE} to return a vector of IDs for the RE
deltas (0 means no RE delta on this arm).
}
\examples{
RE_cor(smoking$studyn, smoking$trtn, contrast = rep(FALSE, nrow(smoking)))
RE_cor(smoking$studyn, smoking$trtn, contrast = rep(FALSE, nrow(smoking)), type = "blshift")
which_RE(smoking$studyn, smoking$trtn, contrast = rep(FALSE, nrow(smoking)))
which_RE(smoking$studyn, smoking$trtn, contrast = rep(FALSE, nrow(smoking)), type = "blshift")
}
