% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rpdirichlet}
\alias{rpdirichlet}
\title{Random Samples from the Product-Dirichlet Distribution}
\usage{
rpdirichlet(n, alpha, options, drop_fixed = TRUE)
}
\arguments{
\item{n}{number of samples}

\item{alpha}{Dirichlet parameters concatenated across independent conditions
(e.g., a1,a2,  b1,b2,b3)}

\item{options}{the number of choice options per item type, e.g., \code{c(2,3)}
for a binary and ternary condition.
The sum of \code{options} must be equal to the length of \code{alpha}.}

\item{drop_fixed}{whether the output matrix includes the last probability for each category
(which is not a free parameter since probabilities must sum to one).}
}
\description{
Random samples from the prior/posterior (i.e., product-Dirichlet) of the unconstrained
product-multinomial model (the encompassing model).
}
\examples{
# standard uniform Dirichlet
rpdirichlet(5, c(1,1,1,1), 4)
rpdirichlet(5, c(1,1,1,1), 4, drop_fixed = FALSE)

# two ternary outcomes: (a1,a2,a3,  b1,b2,b3)
rpdirichlet(5, c(9,5,1,  3,6,6), c(3,3))
rpdirichlet(5, c(9,5,1,  3,6,6), c(3,3), drop_fixed = FALSE)
}
