% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{find.cluster}
\alias{find.cluster}
\title{cluster detection}
\usage{
find.cluster(
  x,
  vec = 1:ncol(x),
  list.cdm = cdms(x, vec = vec),
  mem = as.numeric(1:max(vec)),
  cluster.to.vertex = 1:max(mem),
  vertex.to.cdm = 1:max(mem),
  previous.n.o.cdms = rep(0, max(mem)),
  all.multivariances = numeric(0),
  g = igraph::add.vertices(igraph::graph.empty(, directed = FALSE), max(mem), label =
    sapply(1:max(mem), function(r) paste(colnames(x, do.NULL = FALSE, prefix = "")[vec ==
    r], collapse = ",")), shape = "circle"),
  fixed.rejection.level = NA,
  alpha = 0.05,
  p.adjust.method = "holm",
  verbose = TRUE,
  kvec = 2:max(mem),
  parameter.range = NULL,
  type = "conservative",
  stop.too.many = NULL,
  ...
)
}
\arguments{
\item{x}{matrix with the samples}

\item{vec}{vector, it indicates which columns are initially treated together as one sample}

\item{list.cdm}{list of doubly centered distance matrices}

\item{mem}{numeric vector, its length is the number of vertices, its content is the number of the corresponding cluster for the current iteration, i.e., vertex \code{i} belongs to cluster \code{mem[i]}}

\item{cluster.to.vertex}{vector, contains the cluster to vertex relations, i.e., \code{cluster.to.vertex[i]} is the index of the vertex which represents cluster \code{i}}

\item{vertex.to.cdm}{vector, contains the vertex to doubly centered distance matrix relations, i.e., \code{vertex.to.cdm[i]} is the index of the doubly centered distance matrix in \code{list.cdm} which corresponds to vertex \code{i}}

\item{previous.n.o.cdms}{vector, number of the doubly centered distance matrices in the previous iteration (it is used to ensure that previously check tuples are not checked again)}

\item{all.multivariances}{vector, which contains all distance multivariances which have been calculated so far. Only used to finally return all distance multivariances which have been calculated.}

\item{g}{dependence structure graph}

\item{fixed.rejection.level}{vector, if not \code{NA} the \code{fixed.rejection.level[k]} is used for the k-tuples, instead of a level derived from the significance level \code{alpha}}

\item{alpha}{numeric, significance level used for the (distribution-free) tests}

\item{p.adjust.method}{name of the method used to adjust the p-values for multiple testing, see \code{\link[stats]{p.adjust}} for all possible options.}

\item{verbose}{boolean, if \code{TRUE} details during the detection are printed and whenever a cluster is newly detected the (so far) detected dependence structure is plotted.}

\item{kvec}{vector, k-tuples are only checked for each k in \code{kvec}, i.e., for \code{kvec = 2:4} only 2,3 and 4-tuples would be check and then the algorithm stops.}

\item{parameter.range}{numeric matrix, which hosts the range of significance levels or '\code{c.factor}' which yield the same detected structure}

\item{type}{the method for the detection, one of '\code{conservative}','\code{resample}','\code{pearson_approx}' or '\code{consistent}'.}

\item{stop.too.many}{numeric, upper limit for the number of tested tuples. A warning is issued if it is used. Use \code{stop.too.many = NULL} for no limit.}

\item{...}{are passed to \code{\link{resample.multivariance}} in the case of '\code{type = resample}'}
}
\description{
Performs the detection of dependence structures algorithm until a cluster is found. This function is the basic building block \code{\link{dependence.structure}}. Advanced users, might use it directly.
}
\details{
For further details see \code{\link{dependence.structure}}.
}
