% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{coef.multiview}
\alias{coef.multiview}
\title{Extract coefficients from a multiview object}
\usage{
\method{coef}{multiview}(object, s = NULL, ...)
}
\arguments{
\item{object}{Fitted "multiview" object.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are
required. Default is the entire sequence used to create the model.}

\item{...}{This is the mechanism for passing arguments like \verb{x=} when
\code{exact=TRUE}; see \code{exact} argument.}
}
\value{
a matrix of coefficients for specified lambda.
}
\description{
Extract coefficients from a multiview object
}
\examples{
# Gaussian
x = matrix(rnorm(100 * 20), 100, 20)
z = matrix(rnorm(100 * 10), 100, 10)
y = rnorm(100)
fit1 = multiview(list(x=x,z=z), y, rho = 0)
coef(fit1, s=0.1)

# Binomial
by = sample(c(0,1), 100, replace = TRUE)
fit2 = multiview(list(x=x,z=z), by, family = binomial(), rho=0.5)
coef(fit2, s=0.1)

# Poisson
py = matrix(rpois(100, exp(y))) 
fit3 = multiview(list(x=x,z=z), py, family = poisson(), rho=0.5)
coef(fit3, s=0.1)

}
