% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{chihJenNMF}
\alias{chihJenNMF}
\title{Perform Non-negative Matrix Factorization using Chih-Jen Lin's Algotithm.}
\usage{
chihJenNMF(v, r, params)
}
\arguments{
\item{v}{numeric matrix of Mutation Type Counts}

\item{r}{numeric, number of signatures to extract}

\item{params}{list including all paramaters for running the analysis}
}
\value{
list including all paramaters for running the analysis:
\enumerate{
  \item \bold{W} extracted signatures
  \item \bold{H} contribution of each signature in all the samples of the input mut count matrix
}
}
\description{
Perform Non-negative Matrix Factorization (alternative approach).
}
\details{
This is a core internal function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("chihJenNMF")
y <- mutSignatures:::chihJenNMF(v = x$v, r = x$r, params = x$params)
y$w[1:10, ]

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item \bold{Chih-Jen Lin original paper}: \url{http://ieeexplore.ieee.org/document/4359171/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
