% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{processVCFdata}
\alias{processVCFdata}
\title{Process VCF data.}
\usage{
processVCFdata(vcfData, BSGenomeDb, chr_colName = "CHROM",
  pos_colName = "POS", ref_colName = "REF", alt_colName = "ALT",
  sample_colName = NULL, nucl_contextN = 3, verbose = TRUE)
}
\arguments{
\item{vcfData}{data.frame, includes mutation data from 2 or more samples}

\item{BSGenomeDb}{a BSGenomeDb-class object storing the genomic sequences and coordinates}

\item{chr_colName}{string, name of the column including the chromosome (seq) name. Defaults to "CHROM"}

\item{pos_colName}{string, name of the column including the genomic coordinates/position. Defaults to "POS"}

\item{ref_colName}{string, name of the column including the reference nucleotide. Defaults to "REF"}

\item{alt_colName}{string, name of the column including the variant nucleotide. Defaults to "ALT"}

\item{sample_colName}{string, name of the column including the sample ID. Can be NULL}

\item{nucl_contextN}{integer, span (in nucelotides) of the context around the variants. Defaults to 3}

\item{verbose}{logical, shall information about the ongoing analysis be printed to console}
}
\value{
a data.frame including processed variants from VCF files
}
\description{
Check, annotate, and process variants imported from a list of VCF files, so that it can be used
to run a mutational signature analysis
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
