\name{mvhist}
\alias{mvhist}
\alias{histDirectional}
\alias{histDirectionalQuantileThreshold}
\alias{histDirectionalAbsoluteThreshold}
\alias{histSimplex}
\alias{histRectangular}
\alias{TallyHrep}
\alias{TallyCones}
\alias{DrawPillars}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{Multivariate histograms}
\description{Tabulate and plot histograms for multivariate data, including directional histograms}
\usage{
histDirectional( x, k, p=2, plot.type="default", freq=TRUE, positive.only=FALSE, 
     report="summary", ... )
histDirectionalQuantileThreshold( x, probs=1, p=2, k=3, positive.only=FALSE, ... )
histDirectionalAbsoluteThreshold( x, thresholds=0, p=2, k=3, positive.only=FALSE,...)     
histRectangular( x, breaks=10, plot.type="default", freq=TRUE, report="summary", ... )
histSimplex( x, S, plot.type="default", freq=TRUE, report="summary", ... )

TallyHrep( x, H, report="summary" )  
DrawPillars( S, height, shift=rep(0.0,3), ... )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{data in an (n x d) matrix; rows are d-dimensional data vectors
}
  \item{k}{number of subdivisions
}
  \item{p}{power of p-norm
}
  \item{freq}{TRUE for a frequency histogram, FALSE for a relative frequency histogram
}
  \item{breaks}{specifes the subdivision of the region; see 'breaks' in \code{\link{RectangularMesh}}
}
  \item{plot.type}{type of plot, see details below
}
  \item{positive.only}{If TRUE, look only in the first octant
}
  \item{report}{level of warning messages; one of "summary", "all", "none".
}
  \item{probs}{vector of probabilites specifying what fraction of the extremes to keep
}
  \item{thresholds}{vector of thresholds specifying cutoff for extremes to keep
}
  \item{\dots}{Optional arguments to plot
}
  \item{S}{(vps x d x nS) array of simplices in V representation, see \code{\link{V2Hrep}}
}
  \item{H}{array of simplices in H representation, see \code{\link{V2Hrep}}
}
  \item{height}{vector of length nS giving the heights of the pillars
}
  \item{shift}{shift of the pillars, typically (0,0,0) for 2d data or (0,0,z0) for 3d data
}
}
\details{Calculate and plot multivariate histograms.  
\code{histDirectional} plots a directional histogram for all the data, 
\code{histDirectionalQuantileThreshold} plots \code{m=length(probs)} directional histograms,
with plot i using the top probs[i] fraction of the data, 
\code{histDirectionalAbsoluteThreshold}  plots \code{m=length(cut.off)} directional histograms,
with plot i using the top probs[i] fraction of the data, 
\code{histSimplex} plots histogram based on simplices specified in \code{S},
\code{histRectangular} plots histogram based on a rectangular grid,

In all cases, the bins are simplices computed from some
description computed using the H-representation by \code{TallyHrep}.
\code{TallyCones} does a similar function for cones generated by a list of base simplices.
\code{DrawPillars} is used to plot 3-dimensional 'pillars' showing heights over a simplex.

'plot.type' values depend on the type of plot being used.  Possible values are:
\itemize{
\item "none" - does not show a plot, just return the counts
\item "index" - shows a histogram of simplex index number versus count, does not show the 
   geometry, but works in any dimension
\item "pillars" - shows a 3D plot with pillars/columns having base the shape of the 
   simplices and height proportional to frequency counts.
   When the points are 2D, this works for \code{histRectangular} and \code{histSimplex}; when the points are 3D, this only
   works for \code{histRectangular}
\item "counts" - shows frequency counts as a number in the center of each simplex
\item "radial" - \code{histDirectional} only, shows radial spikes proportional to the counts 
\item "grayscale" - \code{histDirectional} only, shows radial spikes proportional to the counts 
\item "orthogonal" - \code{histDirectional} only, shows radial spikes proportional to the counts 
\item "default" - type depends on the dimension of the data and type of histogram
}
}
\value{A plot is drawn (unless plot.type="none").  A list is returned invisibly, with fields:
\itemize{
\item counts - frequency count in each bin
\item nrejects - number of x values not in any bin
\item nties - number of points in more than one bin (if bins are set up to be non-overlapping, 
   this should only occur on a shared edge between two simplices)
\item nx - total number of data points in x
\item rel.freq - counts/nx
\item rel.rejects - nrejects/nx
\item mesh - object of type mvmesh, see \code{\link{mvmesh}}
\item plot.type - input value
\item report - input value
}
}
\section{Warning}{This is experimental code, and not throughly tested.  If you have problems, please let me know.
}
\examples{

# two dimensional, isotropic
x <- matrix( rnorm(8000), ncol=2 )
histDirectional( x, k=1 )

\dontrun{

histRectangular( x, breaks=5 )

# some directional 2-dim data
n <- 1000
A <- matrix( c(1,2, 4,1), nrow=2,ncol=2)
x2 <- matrix( 0.0, nrow=n, ncol=2 )
for (i in 1:n) { x2[i,] <- A %*% (1/runif(2)) }
dev.new(); par(mfrow=c(2,2))
plot(x2,main="Raw data",col='red')
histDirectionalQuantileThreshold( x2, probs=c(1,0.25,0.1), p=1, 
    positive.only=TRUE, col='green',lwd=3)
dev.new(); par(mfrow=c(2,2))
histDirectionalAbsoluteThreshold( x2, thresholds=c(0,50,100,200), p=1, 
    positive.only=TRUE, col='blue',lwd=3)


# three dimensional positive data
x3 <- matrix( abs(rnorm(9000)), ncol=3 )
histDirectional( x3, k=3, positive.only=TRUE, col='blue', lwd=3 )
histRectangular( x3, breaks=4 )

demo(mvhist) # shows a range of multivariate histograms
}

}
}
