% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvord.R
\docType{data}
\name{data_mvord}
\alias{data_mvord}
\title{Simulated credit ratings}
\format{A data frame with 3000 rows and 9 variables}
\usage{
data(data_mvord)
}
\description{
A simulated data set where three different raters (\code{rater1, rater2} and \code{rater3})
assign ordinal ratings on different firms. \code{rater3} uses a different rating scale
compared to \code{rater1} and \code{rater2}, i.e., the number of threshold categories is different.
For each firm we simulate five different covariates \code{X1, ..., X5} from a standard
normal distribution. Additionally, each firm is randomly assigned to a business sector (sector \code{X}, \code{Y} or \code{Z}), captured by the covariate \code{X6}. Furthermore, we simulate
 multivariate normally distributed errors. For a given set of parameters we obtain the three rating variables for
 each firm by slotting the latent scores according to the corresponding threshold parameters.
The IDs for each subject \eqn{i} of the \eqn{n = 1000} firms are stored in the column \code{firm_id}. The IDs of the raters are stored
in the column \code{rater_id}. The ordinal ratings are provided in the column \code{rating} and all the covariates in the remaining columns.
Overall, the data set has 3000 rows, for each of the \eqn{n = 1000} firms it has three rating observations.
}
\details{
\itemize{
  \item \code{firm_id} firm index
  \item \code{rater_id}  rater index
  \item \code{rating} ordinal credit ratings
  \item \code{X1} covariate X1
  \item \code{X2} covariate X2
  \item \code{X3} covariate X3
  \item \code{X4} covariate X4
  \item \code{X5} covariate X5
  \item \code{X6} covariate X6 (factor)
}
}
