% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_entropy.R
\name{extract_entropy}
\alias{extract_entropy}
\title{extract_entropy}
\usage{
extract_entropy(mxFDAobject, markvar, marks, n_break = 50, rmax = 400)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA}}

\item{markvar}{The name of the variable that denotes cell type(s) of interest. Character.}

\item{marks}{Character vector that denotes cell types of interest.}

\item{n_break}{Total number of distance ranges/intervals of interest made from 0 to \code{rmax} for calculating entropy}

\item{rmax}{Max distance between pairs of cells}
}
\value{
object of class \code{mxFDA} with a dataframe in the \code{multivariate_summaries} slot
}
\description{
The extract_entropy() is used to compute spatial entropy at each distance
interval for all cell types of interest. The goal is to capture the diversity
in cellular composition, such as similar proportions across cell types or
dominance of a single type, at a specific distance range. Additionally,
spatial patterns, including clustered, independent, or regular, among cell
types can also be acquired. In this example, we will look at the spatial
heterogeneity across T cells, macrophages, and others. To focus on the local
cell-to-cell interactions, we set the default maximum of the distance range
(i.e., rmax) to be 400 microns. The default number of distance
breaks/intervals is set to 50. Then, a sequence of distance breaks is
generated by linearly decreasing from rmax to 0 on a log scale. At each
distance range, partial spatial entropy and residual entropy are
calculated as in Vu et al. (2023), Altieri et al. (2018). These spatial
entropy functions can then be used as input functions for FPCA.
}
