% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_moderated_nonlinear_factor_analysis}
\alias{simulate_moderated_nonlinear_factor_analysis}
\title{simulate_moderated_nonlinear_factor_analysis}
\usage{
simulate_moderated_nonlinear_factor_analysis(N)
}
\arguments{
\item{N}{sample size}
}
\value{
data set with variables x1-x3 and y1-y3 representing repeated measurements
of an affect measure. It is assumed that the autoregressive effect is different
depending on covariate k
}
\description{
simulate data for a moderated nonlinear factor analysis.
}
\examples{
library(mxsem)
set.seed(123)
dataset <- simulate_moderated_nonlinear_factor_analysis(N = 2000)

model <- "
xi =~ x1 + x2 + x3
eta =~ y1 + y2 + y3
eta ~ a*xi

# we need two new parameters: a0 and a1. These are created as follows:
!a0
!a1
# Now, we redefine a to be a0 + k*a1, where k is found in the data
a := a0 + data.k*a1
"

mod <- mxsem(model = model,
             data = dataset) |>
  mxTryHard()

omxGetParameters(mod)
}
