% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{mc_states_insert}
\alias{mc_states_insert}
\title{Insert new sensor states (tags)}
\usage{
mc_states_insert(data, states_table)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{states_table}{Output of \code{\link[=mc_info_states]{mc_info_states()}} can be used as template for input data.frame.
data.frame with columns:
\itemize{
\item locality_id - the name of locality (in some cases identical to logger id, see \link{mc_read_files})
\item logger_index - index of logger in myClim object at the locality. See \link{mc_info_logger}.
\item sensor_name - sensor name either original (e.g., TMS_T1, T_C), or calculated/renamed (e.g., "TMS_T1_max", "my_sensor01")
\item tag - category of state (e.g., "conflict", "error", "source", "quality")
\item start - start datetime
\item end - end datetime
\item value - value of tag (e.g., "out of soil", "c:/users/John/tmsData/data_911235678.csv")
}}
}
\value{
myClim object in the same format as input, with inserted sensor states
}
\description{
This function inserts new states (tags) into the selected part of the sensor
time-series. For more information about the structure of states (tags),
see \link{myClim-package}. \code{mc_states_insert()} does not affect
existing rows in the states (tags) table but only inserts new rows even if
the new ones are identical with existing (resulting in duplicated states).
}
\details{
As a template for inserting states (tags), it is recommended to use
the output of \code{\link[=mc_info_states]{mc_info_states()}}, which will return the table with all necessary
columns correctly named. The \code{sensor_name} and \code{value} columns are optional and do not
need to be filled in.

When \code{locality_id} is provided but \code{sensor_name} is NA in the states (tags) table,
states are inserted for all sensors within the locality.

The states (tags) are associated with the sensor time-series, specifically to
the defined part of the time-series identified by start and end date times. A
single time series can contain multiple states (tags) of identical or different types, and these
states (tags) can overlap. Start and end date times are adjusted to fit within
the range of logger/locality datetime and are rounded according to the logger's step. For instance,
if a user attempts to insert a tag beyond the sensor time-series range, \code{mc_states_insert}
will adjust the start and end times to fit the available measurements. If a user defines a start time as
'2020-01-01 10:23:00' on a logger with a 15-minute step, it will be rounded to '2020-01-01 10:30:00'.
}
\examples{
states <- data.frame(locality_id="A1E05", logger_index=1, sensor_name="Thermo_T", tag="error",
                     start=lubridate::ymd_hm("2020-10-28 9:00"),
                     end=lubridate::ymd_hm("2020-10-28 9:30"))
data <- mc_states_insert(mc_data_example_clean, states)
}
