% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-noncommutative.R, R/na.cummax.R
\name{impute-noncommutative}
\alias{impute-noncommutative}
\alias{na.cummax}
\alias{na.cummin}
\alias{na.cumsum}
\alias{na.cumprod}
\title{non-commutative imputation

Impute missing values using non-commutative functions, i.e. where the order
\strong{matters}.}
\usage{
na.cummax(.x, ...)

na.cummin(.x, ...)

na.cumsum(.x, ...)

na.cumprod(.x, ...)
}
\arguments{
\item{.x}{atomic-vector with 0 or more missing values}

\item{...}{additional arguments}
}
\description{
non-commutative imputation

Impute missing values using non-commutative functions, i.e. where the order
\strong{matters}.
}
\details{
Non-commutative imputations functions assume that \code{.x} is in the proper order
since the values depend on order. Usually, this is relevant then \code{.x} is part
of a table.

These functions replaces \code{NA} values with the cummulative max of \code{.x}. Internally,
\code{fun(.x, na.rm=TRUE, ... )} is used. If the function cannot be calculated
(e.g. \code{.x}  isn't numeric) then \code{x} is returned unchanged with a warning.

Use of \code{na.cumsum} and \code{na.cumprod} are dangerous since they omit missing
values that may contribute to
}
\seealso{
\itemize{
\item \code{\link[base:cummax]{base::cummax()}}
\item \link{impute-commutative}
}
}
