% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_below.R
\name{impute_below_at}
\alias{impute_below_at}
\title{Scoped variants of \code{impute_below}}
\usage{
impute_below_at(.tbl, .vars, prop_below = 0.1, jitter = 0.05, ...)
}
\arguments{
\item{.tbl}{a data.frame}

\item{.vars}{variables to impute}

\item{prop_below}{the degree to shift the values. default is}

\item{jitter}{the amount of jitter to add. default is 0.05}

\item{...}{extra arguments}
}
\value{
an dataset with values imputed
}
\description{
\code{impute_below} operates on all variables. To only impute variables
that satisfy a specific condition, use the scoped variants,
\code{impute_below_at}, and \code{impute_below_if}. To use \verb{_at} effectively,
you must know that \verb{_at`` affects variables selected with a character vector, or with }vars()`.
}
\examples{
# select variables starting with a particular string.
library(dplyr)
impute_below_at(airquality,
                .vars = c("Ozone", "Solar.R"))

impute_below_at(airquality,
                .vars = 1:2)
#'
impute_below_at(airquality,
                .vars = vars(Ozone))

\dontrun{
library(ggplot2)
airquality \%>\%
  bind_shadow() \%>\%
  impute_below_at(vars(Ozone, Solar.R)) \%>\%
  add_label_shadow() \%>\%
  ggplot(aes(x = Ozone,
             y = Solar.R,
             colour = any_missing)) +
         geom_point()
}

}
