% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-cols.R
\name{label_missings}
\alias{label_missings}
\title{Is there a missing value in the row of a dataframe?}
\usage{
label_missings(data, ..., missing = "Missing", complete = "Not Missing")
}
\arguments{
\item{data}{a dataframe or set of vectors of the same length}

\item{...}{extra variable to label}

\item{missing}{character a label for when values are missing - defaults to "Missing"}

\item{complete}{character character a label for when values are complete - defaults to "Not Missing"}
}
\value{
character vector of "Missing" and "Not Missing".
}
\description{
Creates a character vector describing presence/absence of missing values
}
\examples{

label_missings(airquality)

library(dplyr)

airquality \%>\%
  mutate(is_missing = label_missings(airquality)) \%>\%
  head()

airquality \%>\%
  mutate(is_missing = label_missings(airquality,
                                     missing = "definitely missing",
                                     complete = "absolutely complete")) \%>\%
  head()

}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_n_miss]{add_n_miss()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}} \code{\link[=cast_shadow]{cast_shadow()}}
}
