% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-recode.R
\name{update_shadow}
\alias{update_shadow}
\title{Expand all shadow levels}
\usage{
update_shadow(data, suffix)
}
\arguments{
\item{data}{data.frame}

\item{suffix}{character vector}
}
\value{
data.frame with adjusted levels
}
\description{
Internal function to appropriately expand and relevel all shadow variables to include a new suffix
}
\examples{
 \dontrun{
df <- tibble::tribble(
~wind, ~temp,
-99,    45,
68,    NA,
72,    25
)


dfs <- bind_shadow(df)

# update_shadow(dfs, "weee")
# update_shadow(dfs, "weee") \%>\% what_levels()
}

}
