% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-array.R
\name{convert_array}
\alias{convert_array}
\title{Convert an Array into an R vector}
\usage{
convert_array(array, to = NULL, ...)
}
\arguments{
\item{array}{A \link[=as_nanoarrow_array]{nanoarrow_array}.}

\item{to}{A target prototype object describing the type to which \code{array}
should be converted, or \code{NULL} to use the default conversion as
returned by \code{\link[=infer_nanoarrow_ptype]{infer_nanoarrow_ptype()}}. Alternatively, a function can be
passed to perform an alternative calculation of the default ptype as
a function of \code{array} and the default inference of the prototype.}

\item{...}{Passed to S3 methods}
}
\value{
An R vector of type \code{to}.
}
\description{
Converts \code{array} to the type specified by \code{to}. This is a low-level interface;
most users should use \code{as.data.frame()} or \code{as.vector()} unless finer-grained
control is needed over the conversion. This function is an S3 generic
dispatching on \code{to}: developers may implement their own S3 methods for
custom vector types.
}
\details{
Conversions are implemented for the following R vector types:
\itemize{
\item \code{\link[=logical]{logical()}}: Any numeric type can be converted to \code{\link[=logical]{logical()}} in addition
to the bool type. For numeric types, any non-zero value is considered \code{TRUE}.
\item \code{\link[=integer]{integer()}}: Any numeric type can be converted to \code{\link[=integer]{integer()}}; however,
a warning will be signaled if the any value is outside the range of the
32-bit integer.
\item \code{\link[=double]{double()}}: Any numeric type can be converted to \code{\link[=double]{double()}}. This
conversion currently does not warn for values that may not roundtrip
through a floating-point double (e.g., very large uint64 and int64 values).
\item \code{\link[=character]{character()}}: String and large string types can be converted to
\code{\link[=character]{character()}}. The conversion does not check for valid UTF-8: if you need
finer-grained control over encodings, use \code{to = blob::blob()}.
\item \link[=as.Date]{Date}: Only the date32 type can be converted to an R Date vector.
\item \code{\link[hms:hms]{hms::hms()}}: Time32 and time64 types can be converted to \code{\link[hms:hms]{hms::hms()}}.
\item \code{\link[=difftime]{difftime()}}: Time32, time64, and duration types can be converted to
R \code{\link[=difftime]{difftime()}} vectors. The value is converted to match the \code{\link[=units]{units()}}
attribute of \code{to}.
\item \code{\link[blob:blob]{blob::blob()}}: String, large string, binary, and large binary types can
be converted to \code{\link[blob:blob]{blob::blob()}}.
\item \code{\link[vctrs:list_of]{vctrs::list_of()}}: List, large list, and fixed-size list types can be
converted to \code{\link[vctrs:list_of]{vctrs::list_of()}}.
\item \code{\link[=data.frame]{data.frame()}}: Struct types can be converted to \code{\link[=data.frame]{data.frame()}}.
\item \code{\link[vctrs:unspecified]{vctrs::unspecified()}}: Any type can be converted to \code{\link[vctrs:unspecified]{vctrs::unspecified()}};
however, a warning will be raised if any non-null values are encountered.
}

In addition to the above conversions, a null array may be converted to any
target prototype except \code{\link[=data.frame]{data.frame()}}. Extension arrays are currently
converted as their storage type; dictionary-encoded arrays are not
currently supported.
}
\examples{
array <- as_nanoarrow_array(data.frame(x = 1:5))
str(convert_array(array))
str(convert_array(array, to = data.frame(x = double())))

}
