% Generated by roxygen2 (4.0.1): do not edit by hand
\name{subset.neuronlist}
\alias{subset.neuronlist}
\title{Subset neuronlist returning either new neuronlist or names of chosen neurons}
\usage{
\method{subset}{neuronlist}(x, subset, filterfun, rval = c("neuronlist",
  "names", "data.frame"), ...)
}
\arguments{
  \item{x}{a neuronlist}

  \item{subset}{An expression that can be evaluated in the
  context of the dataframe attached to the neuronlist. See
  details.}

  \item{filterfun}{a function which can be applied to each
  neuron returning \code{TRUE} when that neuron should be
  included in the return list.}

  \item{rval}{What to return (character vector,
  default='neuronlist')}

  \item{...}{additional arguments passed to
  \code{filterfun}}
}
\value{
A \code{neuronlist}, character vector of names or the
attached data.frame according to the value of \code{rval}
}
\description{
Subset neuronlist returning either new neuronlist or names
of chosen neurons
}
\details{
The subset expression should evaluate to one of \itemize{
\item character vector of names \item logical vector \item
vector of numeric indices } Any missing names are dropped
with a warning. The \code{filterfun} expression is wrapped
in a try. Neurons returning an error will be dropped with a
warning.
}
\examples{
da1pns=subset(Cell07PNs,Glomerulus=='DA1')
with(da1pns,stopifnot(all(Glomerulus=='DA1')))
gammas=subset(kcs20,type=='gamma')
with(gammas,stopifnot(all(type=='gamma')))
# define a function that checks whether a neuron has points in a region in
# space, specifically the tip of the mushroom body alpha' lobe
aptip<-function(x) {xyz=xyzmatrix(x);any(xyz[,'X']>350 & xyz[,'Y']<40)}
# this should identify the alpha'/beta' kenyon cells only
apbps=subset(kcs20,filterfun=aptip)
# look at which neurons are present in the subsetted neuronlist
head(apbps)
# combine global variables with dataframe columns
odds=rep(c(TRUE,FALSE),10)
stopifnot(all.equal(subset(kcs20,type=='gamma' & odds),
            subset(kcs20,type=='gamma' & rep(c(TRUE,FALSE),10))))
\dontrun{
# make a 3d selection function using interactive rgl::select3d() function
s3d=select3d()
# Apply a 3d search function to the first 100 neurons in the neuronlist dataset
subset(dps[1:100],filterfun=function(x) {sum(s3d(xyzmatrix(x)))>0},
  rval='names')
# combine a search by metadata, neuropil location and 3d location
subset(dps, Gender=="M" & rAL>1000, function(x) sum(s3d(x))>0, rval='name')
# The same but specifying indices directly, which can be considerably faster
# when neuronlist is huge and memory is in short supply
subset(dps, names(dps)[1:100],filterfun=function(x) {sum(s3d(xyzmatrix(x)))>0},
  rval='names')
}
}
\seealso{
\code{\link{neuronlist}, \link{subset.data.frame}}
}

