% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{nlapply}
\alias{nlapply}
\alias{nmapply}
\title{lapply and mapply for neuronlists (with optional parallelisation)}
\usage{
nlapply(X, FUN, ..., subset = NULL, OmitFailures = NA, .progress = "auto")

nmapply(FUN, X, ..., MoreArgs = NULL, SIMPLIFY = FALSE, USE.NAMES = TRUE,
  subset = NULL, OmitFailures = NA)
}
\arguments{
\item{X}{A neuronlist}

\item{FUN}{Function to be applied to each element of X}

\item{...}{Additional arguments for FUN (see details)}

\item{subset}{Character, numeric or logical vector specifying on which subset
of \code{X} the function \code{FUN} should be applied. Elements outside the
subset are passed through unmodified.}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an
error. The default value (\code{NA}) will result in nlapply stopping with
an error message the moment there is an eror. For other values, see
details.}

\item{.progress}{Character vector specifying the type of progress bar (see
\code{\link[plyr]{create_progress_bar}} for options.) The default value of
\code{"auto"} shows a progress bar in interactive use when there are >=10
elements in \code{X}.}

\item{MoreArgs}{a list of other arguments to \code{FUN}.}

\item{SIMPLIFY}{logical or character string; attempt to reduce the
    result to a vector, matrix or higher dimensional array; see
    the \code{simplify} argument of \code{\link{sapply}}.}

\item{USE.NAMES}{logical; use names if the first \dots argument has
    names, or if it is a character vector, use that character vector as
    the names.}
}
\value{
A neuronlist
}
\description{
versions of lapply and mapply that look after the class and
  attached dataframe of neuronlist objects. \code{nlapply} can apply a
  function to only a \code{subset} of elements in the input neuronlist.
  Internally \code{nlapply} uses \code{plyr::llply} thereby enabling progress
  bars and simple parallelisation (see plyr section and examples).
}
\details{
When \code{OmitFailures} is not \code{NA}, \code{FUN} will be
  wrapped in a call to \code{try} to ensure that failure for any single
  neuron does not abort the nlapply/nmapply call. When
  \code{OmitFailures=TRUE} the resultant neuronlist will be subsetted down to
  return values for which \code{FUN} evaluated successfully. When
  \code{OmitFailures=FALSE}, "try-error" objects will be left in place. In
  either of the last 2 cases error messages will not be printed because the
  call is wrapped as \code{try(expr, silent=TRUE)}.
}
\section{plyr}{
 The arguments of most interest from plyr are:

  \itemize{

  \item \code{.inform} set to \code{TRUE} to give more informative error
  messages that should indicate which neurons are failing for a given applied
  function.

  \item \code{.progress} set to \code{"text"} for a basic progress bar

  \item \code{.parallel} set to \code{TRUE} for parallelisation after
  registering a parallel backend (see below).

  \item \code{.paropts} Additional arguments for parallel computation. See
  \code{\link[plyr]{llply}} for details.

  }

  Before using parallel code within an R session you must register a suitable
  parallel backend. The simplest example is the multicore option provided by
  the \code{doMC} package that is suitable for a spreading computational load
  across multiple cores on a single machine. An example is provided below.

  Note that the progess bar and parallel options cannot be used at the same
  time. You may want to start a potentially long-running job with the
  progress bar option and then abort and re-run with \code{.parallel=TRUE} if
  it looks likely to take a very long time.
}
\examples{
## nlapply example
kcs.reduced=nlapply(kcs20,function(x) subset(x,sample(nrow(x$points),50)))
open3d()
plot3d(kcs.reduced,col='red', lwd=2)
plot3d(kcs20,col='grey')
rgl.close()

\dontrun{
# example of using plyr's .inform argument for debugging error conditions
xx=nlapply(Cell07PNs, prune_strahler)
# oh dear there was an error, let's get some details about the neuron
# that caused the problem
xx=nlapply(Cell07PNs, prune_strahler, .inform=TRUE)
}

\dontrun{
## nlapply example with plyr
## dotprops.neuronlist uses nlapply under the hood
## the .progress and .parallel arguments are passed straight to
system.time(d1<-dotprops(kcs20,resample=1,k=5,.progress='text'))
## plyr+parallel
library(doMC)
# can also specify cores e.g. registerDoMC(cores=4)
registerDoMC()
system.time(d2<-dotprops(kcs20,resample=1,k=5,.parallel=TRUE))
stopifnot(all.equal(d1,d2))
}

## nmapply example
# flip first neuron in X, second in Y and 3rd in Z
xyzflip=nmapply(mirror, kcs20[1:3], mirrorAxis = c("X","Y","Z"),
 mirrorAxisSize=c(400,20,30))
open3d()
plot3d(kcs20[1:3])
plot3d(xyzflip)
rgl.close()
}
\seealso{
\code{\link{lapply}}

\code{\link{mapply}}

Other neuronlist: \code{\link{*.neuronlist}},
  \code{\link{+.neuronlist}}, \code{\link{-.neuronlist}},
  \code{\link{/.neuronlist}}; \code{\link{[.neuronlist}},
  \code{\link{[<-.neuronlist}}, \code{\link{droplevels}},
  \code{\link{droplevels.neuronlist}}, \code{\link{head}},
  \code{\link{head.neuronlist}},
  \code{\link{neuronlist-dataframe-methods}},
  \code{\link{neuronlist-dataframe-methods}},
  \code{\link{tail}}, \code{\link{tail.neuronlist}},
  \code{\link{with}}, \code{\link{with.neuronlist}};
  \code{\link{as.neuronlistfh}},
  \code{\link{as.neuronlistfh.neuronlist}},
  \code{\link{is.neuronlistfh}},
  \code{\link{neuronlistfh}}, \code{\link{neuronlistfh}};
  \code{\link{is.neuronlist}}; \code{\link{neuronlist}};
  \code{\link{read.neurons}}; \code{\link{write.neurons}}
}

