% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuron-plot.R
\name{plot.neuron}
\alias{plot.neuron}
\title{Plot a 2D projection of a neuron}
\usage{
\method{plot}{neuron}(
  x,
  WithLine = TRUE,
  WithNodes = TRUE,
  WithAllPoints = FALSE,
  WithText = FALSE,
  PlotSubTrees = TRUE,
  soma = FALSE,
  PlotAxes = c("XY", "YZ", "XZ", "ZY"),
  axes = TRUE,
  asp = 1,
  main = x$NeuronName,
  sub = NULL,
  xlim = NULL,
  ylim = NULL,
  AxisDirections = c(1, -1, 1),
  add = FALSE,
  col = NULL,
  PointAlpha = 1,
  tck = NA,
  lwd = par("lwd"),
  boundingbox = NULL,
  ...
)
}
\arguments{
\item{x}{a neuron to plot.}

\item{WithLine}{whether to plot lines for all segments in neuron.}

\item{WithNodes}{whether points should only be drawn for nodes (branch/end 
points)}

\item{WithAllPoints}{whether points should be drawn for all points in neuron.}

\item{WithText}{whether to label plotted points with their id.}

\item{PlotSubTrees}{Whether to plot all sub trees when the neuron is not 
fully connected.}

\item{soma}{Whether to plot a circle at neuron's origin representing the 
soma. Either a logical value or a numeric indicating the radius (default 
\code{FALSE}). When \code{soma=TRUE} the radius is hard coded to 2.}

\item{PlotAxes}{the axes for the plot.}

\item{axes}{whether axes should be drawn.}

\item{asp}{the \code{y/x} aspect ratio, see \code{\link{plot.window}}.}

\item{main}{the title for the plot}

\item{sub}{sub title for the plot}

\item{xlim}{limits for the horizontal axis (see also boundingbox)}

\item{ylim}{limits for the vertical axis (see also boundingbox)}

\item{AxisDirections}{the directions for the axes. By default, R uses the 
bottom-left for the origin, whilst most graphics software uses the 
top-left. The default value of \code{c(1, -1, 1)} makes the produced plot 
consistent with the latter.}

\item{add}{Whether the plot should be superimposed on one already present 
(default: \code{FALSE}).}

\item{col}{the color in which to draw the lines between nodes.}

\item{PointAlpha}{the value of alpha to use in plotting the nodes.}

\item{tck}{length of tick mark as fraction of plotting region (negative 
number is outside graph, positive number is inside, 0 suppresses ticks, 1 
creates gridlines).}

\item{lwd}{line width relative to the default (default=1).}

\item{boundingbox}{A 2 x 3 matrix (ideally of class 
\code{\link{boundingbox}}) that enables the plot axis limits to be set 
without worrying about axis selection or reversal (see details)}

\item{...}{additional arguments passed to plot}
}
\value{
list of plotted points (invisibly)
}
\description{
Plot a 2D projection of a neuron
}
\details{
This functions sets the axis ranges based on the chosen
  \code{PlotAxes} and the range of the data in \code{x}. It is still possible
  to use \code{PlotAxes} in combination with a \code{boundingbox}, for
  example to set the range of a plot of a number of objects.
  
  nat assumes the default axis convention used in biological imaging, where
  the origin of the y axis is the top rather than the bottom of the plot.
  This is achieved by reversing the y axis of the 2D plot when the second
  data axis is the Y axis of the 3D data. Other settings can be achieved by
  modfiying the AxisDirections argument.
}
\examples{
# Draw first example neuron
plot(Cell07PNs[[1]])
# Overlay second example neuron
plot(Cell07PNs[[2]], add=TRUE)
# Clear the current plot and draw the third neuron from a different view
plot(Cell07PNs[[3]], PlotAxes="YZ")
# Just plot the end points for the fourth example neuron
plot(Cell07PNs[[4]], WithNodes=FALSE)
# Plot with soma (of default radius)
plot(Cell07PNs[[4]], WithNodes=FALSE, soma=TRUE)
# Plot with soma of defined radius
plot(Cell07PNs[[4]], WithNodes=FALSE, soma=1.25)
}
\seealso{
\code{\link{plot3d.neuron}}

Other neuron: 
\code{\link{neuron}()},
\code{\link{ngraph}()},
\code{\link{potential_synapses}()},
\code{\link{prune}()},
\code{\link{resample}()},
\code{\link{rootpoints}()},
\code{\link{spine}()},
\code{\link{subset.neuron}()}
}
\concept{neuron}
