% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_inq_file.R
\name{nc_inq}
\alias{nc_inq}
\alias{nc_inq.NetCDF}
\alias{nc_inq.character}
\title{File info}
\usage{
nc_inq(x, ...)

\method{nc_inq}{NetCDF}(x, ...)

\method{nc_inq}{character}(x, ...)
}
\arguments{
\item{x}{filename or handle}

\item{...}{ignored}
}
\description{
Get information about a NetCDF data source, may be a file path, or a \code{RNetCDF}
file handle, or an OpenDAP/Thredds server address.
}
\examples{
\donttest{
\dontrun{
 f <- raadfiles:::cmip5_files()$fullname[1]
 nc_inq(f)
 nc_var(f, 0)
 nc_dim(f, 0)
 }
}
f <- system.file("extdata", "S2008001.L3m_DAY_CHL_chlor_a_9km.nc", package = "ncmeta")
nc_inq(f)
nc_var(f, 0)
nc_dim(f, 0)

nc_vars(f)
nc_dims(f)
\donttest{
\dontrun{
## thredds (see rerddap)
u <- "https://upwell.pfeg.noaa.gov/erddap/tabledap/FRDCPSTrawlLHHaulCatch"
nc_inq(u)
# A tibble: 1 x 5
#ndims nvars ngatts unlimdimid
#<dbl> <dbl>  <dbl>      <lgl>
#  1     2    18     37         NA
# ... with 1 more variables: filename <chr>
}}
}
