% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_cell.R
\name{group_cell}
\alias{group_cell}
\title{Group cells according to subject IDs}
\usage{
group_cell(count, id, pred = NULL, offset = NULL)
}
\arguments{
\item{count}{A raw count matrix of the single-cell data. The rows are the genes, and the columns are the cells. The matrix can be a matrix object or a sparse dgCMatrix object.}

\item{id}{A vector of subject IDs. The length should be the same as the number of columns of the count matrix.}

\item{pred}{A design matrix of the predictors. The rows are the cells and the columns are the predictors. If not specified, an intercept column will be generated by default.}

\item{offset}{A vector of the scaling factor. The values must be strictly positive. If not specified, a vector of all ones will be generated by default.}
}
\value{
count: A reordered count matrix. If the cells are already grouped, the function returns NULL.

id: A reordered subject ID vector.

pred: A reordered design matrix of the predictors.

offset: A reordered vector of the scaling factor.
}
\description{
Group cells according to subject IDs
}
\examples{
library(nebula)
data(sample_data)
pred = model.matrix(~X1+X2+cc,data=sample_data$pred)
df_order = group_cell(count=sample_data$count,id=sample_data$sid,pred=pred)

}
