% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.paired.R
\name{neg.paired}
\alias{neg.paired}
\title{Negligible Effect Test on the Difference between the Means of Dependent Populations}
\usage{
neg.paired(
  var1 = NULL,
  var2 = NULL,
  outcome = NULL,
  group = NULL,
  ID = NULL,
  eil,
  eiu,
  normality = TRUE,
  nboot = 10000,
  alpha = 0.05,
  plot = TRUE,
  saveplot = FALSE,
  data = NULL,
  seed = NA,
  ...
)
}
\arguments{
\item{var1}{Data for Group 1 (if outcome, group and ID are omitted)}

\item{var2}{Data for Group 2 (if outcome, group and ID are omitted)}

\item{outcome}{Dependent Variable (if var1 and var2 are omitted)}

\item{group}{Dichotomous Predictor/Independent Variable (if var1 and var2 are omitted)}

\item{ID}{participant ID (if var1 and var2 are omitted)}

\item{eil}{Lower Bound of the Equivalence Interval}

\item{eiu}{Upper Bound of the Equivalence Interval}

\item{normality}{Are the population variances (and hence the residuals) assumed to be normally distributed?}

\item{nboot}{Number of bootstrap samples for calculating CIs}

\item{alpha}{Nominal Type I Error rate}

\item{plot}{Should a plot of the results be produced?}

\item{saveplot}{Should the plot be saved?}

\item{data}{Dataset containing var1/var2 or outcome/group/ID}

\item{seed}{Seed number}

\item{...}{Extra arguments}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{meanx} Sample mean of the first population/group.
  \item \code{meany} Sample mean of the second population/group.
  \item \code{medx} Sample median of the first population/group.
  \item \code{medy} Sample median second population/group.
  \item \code{sdx} Sample standard deviation of the first population/group.
  \item \code{sdy} Sample standard deviation of the second population/group.
  \item \code{madx} Sample median absolute deviation of the first population/group.
  \item \code{mady} Sample median absolute deviation of the second population/group.
  \item \code{eil} Lower bound of the negligible effect (equivalence) interval.
  \item \code{eiu} Upper bound of the negligible effect (equivalence) interval.
  \item \code{effsizeraw} Simple difference in the means (or medians if normality = FALSE)
  \item \code{cilraw2} Lower bound of the 1-alpha CI for the raw mean difference.
  \item \code{ciuraw2} Upper bound of the 1-alpha CI for the raw mean difference.
  \item \code{cilraw} Lower bound of the 1-2*alpha CI for the raw mean difference.
  \item \code{ciuraw} Upper bound of the 1-2*alpha CI for the raw mean difference.
  \item \code{effsized} Standardized mean (or median if normality = FALSE) difference.
  \item \code{cild} Lower bound of the 1-alpha CI for the standardized mean (or median if normality = FALSE) difference.
  \item \code{ciud} Upper bound of the 1-alpha CI for the standardized mean (or median if normality = FALSE) difference.
  \item \code{effsizepd} Proportional distance statistic.
  \item \code{cilpd} Lower bound of the 1-alpha CI for the proportional distance statistic.
  \item \code{ciupd} Upper bound of the 1-alpha CI for the proportional distance statistic.
  \item \code{t1} First t-statistic from the TOST procedure.
  \item \code{t1} Second t-statistic from the TOST procedure.
  \item \code{df1} Degrees of freedom for the first t-statistic from the TOST procedure.
  \item \code{df2} Degrees of freedom for the second t-statistic from the TOST procedure.
  \item \code{pval1} p value associated with the first t-statistic from the TOST procedure.
  \item \code{pval2} p value associated with the second t-statistic from the TOST procedure.
  \item \code{alpha} Nominal Type I error rate
  \item \code{seed} Seed number
}
}
\description{
This function allows researchers to test whether the difference
between the means of two dependent populations is negligible, where
negligible represents the smallest meaningful effect size (MMES)
}
\details{
This function evaluates whether the difference in the means of 2 dependent populations can be considered negligible (i.e., the population means can be considered equivalent).

The user specifies either the data associated with the first and second groups/populations (var1, var2, both should be continuous) or specifies the Indepedent Variable/Predictor (group, should be a factor) and the Dependent Variable (outcome, should be continuous). A 'data' statement can be used if the variables are stored in an R dataset.

The user must also specify the lower and upper bounds of the negligible effect (equivalence) interval. These are specified in the original units of the outcome variable.
}
\examples{
#wide format
ID<-rep(1:20)
control<-rnorm(20)
intervention<-rnorm(20)
d<-data.frame(ID, control, intervention)
head(d)
neg.paired(var1=control,var2=intervention,eil=-1,eiu=1,plot=TRUE,
           data=d)
neg.paired(var1=d$control,var2=d$intervention,eil=-1,eiu=1,plot=TRUE)
neg.paired(var1=d$control,var2=d$intervention,eil=-1,eiu=1,normality=FALSE,
           plot=TRUE)

\dontrun{
#long format
sample1<-sample(1:20, 20, replace=FALSE)
sample2<-sample(1:20, 20, replace=FALSE)
ID<-c(sample1, sample2)
group<-rep(c("control","intervention"),c(20,20))
outcome<-c(control,intervention)
d<-data.frame(ID,group,outcome)
neg.paired(outcome=outcome,group=group,ID=ID,eil=-1,eiu=1,plot=TRUE,data=d)
neg.paired(outcome=d$outcome,group=d$group,ID=d$ID,eil=-1,eiu=1,plot=TRUE)
neg.paired(outcome=d$outcome,group=d$group,ID=d$ID,eil=-1,eiu=1,plot=TRUE, normality=FALSE)

#long format with multiple variables
sample1<-sample(1:20, 20, replace=FALSE)
sample2<-sample(1:20, 20, replace=FALSE)
ID<-c(sample1, sample2)
attendance<-sample(1:3, 20, replace=TRUE)
group<-rep(c("control","intervention"),c(20,20))
outcome<-c(control,intervention)
d<-data.frame(ID,group,outcome,attendance)
neg.paired(outcome=outcome,group=group,ID=ID,eil=-1,eiu=1,plot=TRUE,data=d)
neg.paired(outcome=d$outcome,group=d$group,ID=d$ID,eil=-1,eiu=1,plot=TRUE)

#open a dataset
library(negligible)
d<-perfectionism
names(d)
head(d)
neg.paired(var1=atqpre.total,var2=atqpost.total,
           eil=-10,eiu=10,data=d)

#Dataset with missing data
x<-rnorm(10)
x[c(3,6)]<-NA
y<-rnorm(10)
y[c(7)]<-NA
neg.paired(x,y,eil=-1,eiu=1, normality=FALSE)
}
}
\author{
Rob Cribbie \email{cribbie@yorku.ca}
  Naomi Martinez Gutierrez \email{naomimg@yorku.ca}
}
